﻿var successURL = 'https://www.facebook.com/connect/login_success.html';

function getUTM(name)
{
    if(localStorage.getItem(name))
        return localStorage.getItem(name);
    return "";
}

function onFacebookLogin() {
    chrome.tabs.getAllInWindow(null, function (tabs) {
        for (var i = 0; i < tabs.length; i++) {
            if (tabs[i].url.indexOf(successURL) == 0) {
                var params = tabs[i].url.split('#')[1];
                var utm_source = getUTM('forhanks_utm_source');
                var utm_medium = getUTM('forhanks_utm_medium');
                var utm_name = getUTM('forhanks_utm_name');
                var utm_term = getUTM('forhanks_utm_term');
                var seller = getUTM('forhanks_utm_content');
                accessToken = params.split('&')[0].replace("access_token=", "");
                chrome.tabs.get(tabs[i].id, function () {
                    if (chrome.runtime.lastError) {
                        console.log(chrome.runtime.lastError.message);
                    } else {
                        chrome.tabs.remove(tabs[i].id);
                    }
                });
                $.ajax({
                    type: "POST",
                    url: "https://laysodienthoai.efy.vn/api/Members/loginfb",
                    data: { accessToken: accessToken,
                        utm_source:utm_source,
                        utm_medium:utm_medium, 
                        utm_name:utm_name,
                        utm_term:utm_term,
                        seller:seller},
                        dataType: "json",
                        success: function (response) {
                            if (response.status == 200) {
                                localStorage.accessToken = response.message.user.authcode;
                            }
                            console.log(tabs[i].id);
                    }
                });
                return;
            }
        }
    });
}

function LoginAccount(data, callback) {

    $.ajax({
            type: "POST",
            url: "https://laysodienthoai.efy.vn/api/Members/accountLogin",
            data: data,
            dataType: "json",
            success: function (response) {
                callback(response);
            }
    });

}

async function getUid(uid, type) {
  try {
    uid = uid.replace(/[^a-z0-9.]/gi, "");
    if (type !== "uid") {
      let url = "https://mbasic.facebook.com/" + uid + "/about";
      return await $.ajax({
        type: "GET",
        url: url,
      }).then((response) => {
        var uid = /owner_id=([0-9]+)/gm.exec(response);

        if (uid) uid = uid[1];
        else {
          var uid = /&amp;id=([0-9]+)&amp;set=/gm.exec(response);
          if (uid) uid = uid[1];
          else uid = false;
        }        
        return uid;
      });
    } else return uid;
  } catch (error) {
    return false;
  }
}

chrome.tabs.onUpdated.addListener(onFacebookLogin);

chrome.runtime.onMessage.addListener(
    function (request, sender, sendResponse) {
        if (request.status == "getphone") {
            if (localStorage.accessToken) {
                (async () => {
                    let uid = await getUid(request.uid, request.type);
                    if (uid == false) {
                          sendResponse({
                            status: 400,
                            data: "Không thể quét fb này",
                            picture:
                              "http://icons.iconarchive.com/icons/custom-icon-design/flatastic-1/64/cancel-icon.png",
                          });
                    } else {
                        var param = $.param({
                            uid: uid,
                            src: request.src,
                            src_link: request.src_link,
                            uname: encodeURIComponent(request.uname),
                            secretkey: request.skey,
                            version: chrome.runtime.getManifest().version
                        }, true );

                        param = decodeURIComponent(param);
                        $.ajax({
                            cache: false,
                            url: "https://laysodienthoai.efy.vn/api/Members/getTel?" + param,
                            type: "get",
                            headers: {
                                authorization: localStorage.accessToken
                            },
                            dataType: "json",
                            success: function (res) {
                                if (res.status==200 || res.status==201) {
                                    var phone = res.message.data.phone.toString().replace(/^84/, "0");
                                    sendResponse({ status: res.status, data: phone, picture:res.message.data.picture, email:res.message.data.email, location:res.message.data.location});
                                }
                                else {
                                    sendResponse({ status: res.status, data:  res.message, picture: 'http://icons.iconarchive.com/icons/custom-icon-design/flatastic-1/64/cancel-icon.png', email:"", location:""});
                                }
                            }
                        });
                    }
                })();

            } else {
                sendResponse({ status: 400, data: "Vui lòng đăng nhập extension" , picture: 'http://icons.iconarchive.com/icons/custom-icon-design/flatastic-1/64/cancel-icon.png', email:"", location:""});
            }
        }

        if (request.status == "checkUser") {
            if (localStorage.accessToken) {
                $.ajax({
                    cache: false,
                    url: "https://laysodienthoai.efy.vn/api/Members/checkUser",
                    type: "get",
                    headers: {
                        authorization: localStorage.accessToken
                    },
                    dataType: "json",
                    success: function (res) {
                        sendResponse({ status: res.status});
                    }
                });
            } else {
                sendResponse({ status: 400, data: "Vui lòng đăng nhập extension" , picture: 'http://icons.iconarchive.com/icons/custom-icon-design/flatastic-1/64/cancel-icon.png', email:"", location:""});
            }
        }

        if (request.status == "scanPost") {
            if (localStorage.accessToken) {
                var surl= "https://laysodienthoai.efy.vn/api/Members/scanpost?idpost=" + request.idpost + "&secretkey=" + request.skey+"&authcode="+ btoa(localStorage.accessToken);
                console.log(surl);
                chrome.tabs.create({ url: surl});
                sendResponse({ success: true })
            } else {
                sendResponse({ status: 400, data: "Vui lòng đăng nhập extension" , picture: 'http://icons.iconarchive.com/icons/custom-icon-design/flatastic-1/64/cancel-icon.png', email:"", location:""});
            }
        }
        else if (request.status == "login") {
            chrome.tabs.create({ url: "https://www.facebook.com/dialog/oauth?client_id="+localStorage.forhanksAppid+"&response_type=token&scope=email&redirect_uri=https://www.facebook.com/connect/login_success.html", email:"", location:""});
            sendResponse({ success: true })
        }
        return true;
    });