﻿var style = `
<style type='text/css' id='exc-style'>

.notify * {
    -webkit-box-sizing: border-box;
    -moz-box-sizing: border-box;
    box-sizing: border-box;
}

.notify {
    position: fixed;
    min-width: 350px;
    max-width: 450px;
    background: #ffff;
    font-size: 14px;
    font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
    color: #494949;
    border-radius: 4px;
    border: 1px solid #dedede;
    box-shadow: rgba(0, 0, 0, 0.0980392) 0px 2px 4px;
    z-index: 999;
    // opacity: .8;
    // filter: alpha(opacity=80);
}

.notify:hover {
    opacity: 1;
    filter: alpha(opacity=100);
}

.notify .notify-icon {
    float: left;
    position: absolute;
    width: 50px;
    height: 100%;
    border-right: 1px solid #ddd;
    text-align: center;
    overflow: hidden;
}

.notify .notify-icon .notify-icon-inner {
    position: relative;
    top: 50%;
    margin-top: -9px;
}

.notify .notify-icon .notify-icon-inner img {
    max-width: 40px;
    max-height: 40px;
}

.notify .notify-text {
    float: left;
    padding: 10px 15px;
    margin-left: 50px;
    width:72%;
}

.notify .notify-text h3 {
    display: block;
    padding: 0;
    margin: 3px 0;
    font-size: 14px;
    font-weight: bold;
    line-height: normal;
}
.notify .notify-text h4 {
    display: block;
    padding: 0;
    margin: 3px 0;
    font-size: 12px;
    font-weight: bold;
    line-height: normal;
}

.notify .notify-text p {
    margin: 5px 0;
    margin-bottom: 0;
    padding: 0;
    font-size: 12px;
    font-weight: normal;
    line-height: 14px;
}

.notify .notify-close-btn {
    position: absolute;
    display: block;
    width: 10px;
    height: 10px;
    right: -10px;
    top: -10px;
    cursor: pointer;
    background: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpGNzdGMTE3NDA3MjA2ODExOEMxNDkyODc0N0NBMUEwNCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo3N0ZBOTUxNzNERkIxMUUyQUZGMEFDRjY0RjNFODlDOCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo3N0ZBOTUxNjNERkIxMUUyQUZGMEFDRjY0RjNFODlDOCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IE1hY2ludG9zaCI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOkY3N0YxMTc0MDcyMDY4MTE4MDgzRkQyMTE2MTM0QUNBIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOkY3N0YxMTc0MDcyMDY4MTE4QzE0OTI4NzQ3Q0ExQTA0Ii8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+5Ke+4QAAAMlJREFUeNqkk90KwyAMha0dvp/ghfthsFcb67YLYe83EBdZlCxL3KCFU0nM+WqjTqUUs+bZ1Nd2d6jDDDqDHqCk1AeQBx1B+Xa9vAFovmNBwFwSzAvIoWKFWJxciNGxmJtp3FeQMDkziCEfcCTObYUUEPE3JAg3xwawZKJBMsm5kZkDNIhqlgC0+J/cFyAIDTOD3fkABKXbeQSxP8xRaWyHNIAfdFvbHU8BJ9JdqdscktDTD9ITtCcnTLpMDRLwMlWPmdZe55cAAwD+1kOdnSr5eQAAAABJRU5ErkJggg==') no-repeat center;
    background-size: 10px,10px;
    background-color: #fff;
    padding: 10px;
    border-radius: 50%;
    border: 1px solid #ddd;
}

.notify .notify-close-btn:hover {
    background-color: #f3f3f3;
}

.notify .notify-close-btn:active {
    background-color: #ddd;
}

/* themes */
.notify.dark-theme {
    background: rgba(44,46,47,.9);
    color: #fafafa;
    border-color: #333;
    box-shadow: rgba(0, 0, 0, 0.3) 0px 2px 4px;
}

.notify.dark-theme .notify-icon {
    border-color: rgba(44,46,47,1);
}

.notify.dark-theme .notify-close-btn {
    background: url('data:image/png;base64,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') no-repeat center;
    background-size: 10px,10px;
    background-color: rgba(44,46,47,.9);
    border: 1px solid #333;
}

.notify.dark-theme .notify-close-btn:hover {
    background-color: #313131;
}

.notify.dark-theme .notify-close-btn:active {
    background-color: #222;
}

.notify.success {
    background: white;
    color: #000000;
    border-color: #e9ebee;
}

.notify.success .notify-icon,
.notify.success .notify-close-btn {
    border-color: #d4d7dc;
}

.notify.error {
    background: #F77975;
    color: #fff;
    border-color: #ffc23700;
}
.notify-icon-inner
{
    margin-top:20px;
}
.notify.error .notify-icon,
.notify.error .notify-close-btn {
    border-color: black;
}

.notify.info {
    background: #78C5E7;
    color: #fff;
    border-color: #ffc23700;
}

.notify.info .notify-icon,
.notify.info .notify-close-btn {
    border-color: #e9ebee;
}

.notify.warning {
    background: #ffeaa8;
    color: #826200;
    border-color: #e9ebee;
}

.notify.warning .notify-icon,
.notify.warning .notify-close-btn {
    border-color: #ffc237;
}

/* sizes */
.notify.size-small {
    min-width: 250px;
    max-width: 350px;
    font-size: 12px;
}

.notify.size-small .notify-text h3 {
    font-size: 12px;
}

.notify.size-small .notify-text p {
    font-size: 10px;
}

/* positions */
.notify.notify-top-left {
    top: 20px;
    left: 20px;
}

.notify.notify-top-right {
    top: 20px;
    right: 20px;
}

.notify.notify-top-center {
    top: 20px;
    left: 50%;
    margin-left: -196px;
}

.notify.notify-bottom-left {
    bottom: 20px;
    left: 20px;
}

.notify.notify-bottom-right {
    bottom: 20px;
    right: 20px;
}

.notify.notify-bottom-center {
    bottom: 20px;
    left: 50%;
    margin-left: -196px;
}

.notify.notify-top-full {
    max-width: none;
    top: -1px;
    bottom: auto;
    right: 50px;
    left: 50px;
    border-top-left-radius: 0;
    border-top-right-radius: 0;
}

.notify.notify-top-full .notify-close-btn,
.notify.notify-top-center .notify-close-btn {
    top: auto;
    bottom: -10px;
}

.notify.notify-bottom-full {
    max-width: none;
    bottom: -1px;
    right: 50px;
    left: 50px;
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
}

.notify.notify-center-center {
    top: 50%;
    left: 50%;
    margin-left: -196px;
    margin-top: -26px;
}

/*options*/
.notify.notify-without-title .notify-text h3 {
    margin: 5px 0;
}

.notify.notify-without-title .notify-text p {
    margin-bottom: 5px;
}

.notify.notify-without-icon .notify-text {
    margin-left: 0;
}

.notify-overlay {
    position: fixed;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    background: rgba(0,0,0,0.05);
    z-index: 998;
}

.notify-overlay.light {
    background: rgba(255,255,255,0.3);
}

/* forhanks cmt v1.0 */
.forhanks-cmt
{
    margin-left: 10px;
    width: 110px;
    padding: 2px 4px 0px 0px;
    background: #337ab7;
    font-size: 12px;
    color: #fff;
    border: 0;
    margin-right: 25px;
    border-radius: 20px;
    cursor: pointer;
    padding-left: 15px;
    float: right;
    margin-top: -15px;
    text-align: center;
}

.forhanks-cmt > div img
{
    content:url("https://static.xx.fbcdn.net/images/emoji.php/v9/t21/1/28/260e.png");
}

.forhanks-cmt:after {
   // content: "Lấy SĐT";
}

.forhanks-cmt:hover
{
    background:#cc9900;
}

.forhanks-cmt.found
{
    background:#00b300;
}

.forhanks-cmt.found > div img
{
    content:url("https://icons.iconarchive.com/icons/custom-icon-design/flatastic-9/16/Accept-icon.png");
}

.forhanks-cmt.found:after {
   // content: "Đã thấy";
}

.forhanks-cmt.notfound
{
    background:#ff3333;
}

.forhanks-cmt.notfound:after {
    //content: "Ko Thấy";
}

.forhanks-cmt.notfound > div img
{
    content:url("https://icons.iconarchive.com/icons/martz90/circle-addon2/16/warning-icon.png");
}

.forhanks-cmt.loading
{
    background:#ff751a;
}

.forhanks-cmt.loading:after {
 // content: "Đang tìm";
}

.forhanks-cmt.loading > div img
{
    width: 16px;
    height: 16px;
    content:url("https://forhanks.com/images/loading.gif");
}

.forhanks-cmt.loading:hover
{
    background:red;
}

/* forhanks pancake v1.0 */
.forhanks-pancake
{   
 width: 100px;
 font-size: 12px;
 vertical-align: middle;
 background-color: #337ab7;
 color: #fff;
 border-radius: 13px;
 padding: 7px;
 padding-right: 20px;
 margin-right: 14px;
 cursor: pointer;
 background-position: right 8px bottom 6px;
 background-repeat: no-repeat;
 background-size: 14px 14px;
 background-image: url(https://static.xx.fbcdn.net/images/emoji.php/v9/t21/1/28/260e.png);
 padding-top: 7px;
 line-height: 15px;
}

.forhanks-pancake:after {
    //content: "Lấy SĐT";
}

.forhanks-pancake:hover
{
    background:#cc9900;
    background-position: right 8px bottom 6px;
    background-repeat: no-repeat;
    background-size: 14px 14px;
    background-image: url(https://static.xx.fbcdn.net/images/emoji.php/v9/t21/1/28/260e.png);
}

.forhanks-pancake.found
{
    background:#00b300;
    background-position: right 8px bottom 6px;
    background-repeat: no-repeat;
    background-size: 14px 14px;
    background-image: url(https://icons.iconarchive.com/icons/custom-icon-design/flatastic-9/16/Accept-icon.png);
}

.forhanks-pancake.found:after {
    // content: "Đã thấy";
}

.forhanks-pancake.notfound
{
    background:#ff3333;
    background-position: right 8px bottom 6px;
    background-repeat: no-repeat;
    background-size: 14px 14px;
    background-image: url("https://icons.iconarchive.com/icons/martz90/circle-addon2/16/warning-icon.png");
}

.forhanks-pancake.notfound:after {
    content: "Ko Thấy";
}


.forhanks-pancake.loading
{
    background:#ff751a;
    background-position: right 8px bottom 6px;
    background-repeat: no-repeat;
    background-size: 14px 14px;
    background-image: url("https://forhanks.com/images/loading.gif");
}

.forhanks-pancake.loading:after {
    content: "Đang tìm";
}

.forhanks-pancake.loading:hover
{
    background:red;
    background-position: right 8px bottom 6px;
    background-repeat: no-repeat;
    background-size: 14px 14px;
    background-image: url("https://forhanks.com/images/loading.gif");
}


/* forhanks-chat v1.0*/
.forhanks-chat
{
    background-image:url(https://static.xx.fbcdn.net/images/emoji.php/v9/t21/1/28/260e.png);
    background-position: 3px 5px;
    background-size: 14px 14px;
    background-repeat:no-repeat
}

.forhanks-chat.found
{
    background-image:url(https://icons.iconarchive.com/icons/custom-icon-design/flatastic-9/16/Accept-icon.png);
}

.forhanks-chat.notfound
{
    background-image:url(https://icons.iconarchive.com/icons/martz90/circle-addon2/16/warning-icon.png);
}

.forhanks-chat.loading
{
    background-image:url(https://forhanks.com/images/loading.gif);
}
.fbNub._50mz .loading {
    display: block;
    margin-top: 0px;
}
// ._3-a6._4eno ._10la._10lg ._10lp {
    //     bottom: 0px;
    //     transform: translateY(-3px);
    // }
    ._2e7q .UFICommentContent
    {
       // max-width: 175px !important;
       // float: left !important;
   }
   #fbPhotoSnowliftFeedback .UFICommentContent
   {
       max-width: 145px !important;
       float: left !important;
   }
   .UFICommentContent
   {
       // max-width: 280px !important;
       // float: left !important;
   }
   .Facetel-Copy
   {
    background: #40b8ff;
    border: 0;
    padding: 7px;
    border-radius: 24px;
    color: white;
    margin: -12% 15px 0px 0px;
    box-shadow: 1px 2px #969696;
    float: right;
}
._3-a6._5vsj.UFIContainer .UFIReplyList .UFIRow.UFIComment
{
    padding-right:0px;
}

.forhanks-post {
    right: auto;
    z-index: 1;
    position: relative;
    float: right;
    width: 100px;
    font-size: 12px;
    vertical-align: middle;
    background-color: #FF6633;
    color: #fff;
    border-radius: 13px;
    padding: 7px;
    padding-right: 20px;
    margin-right: 14px;
    cursor: pointer;
    background-position: right 8px bottom 6px;
    background-repeat: no-repeat;
    background-size: 20px 20px;
    background-image: url(http://icons.iconarchive.com/icons/dtafalonso/android-l/24/WhatsApp-icon.png);
    padding-top: 7px;
    line-height: 15px;
}

.forhanks-copy
{
    margin-left: 10px;
    width: 110px;
    padding: 2px 4px 0px 0px;
    font-size: 12px;
    color: #fff;
    border: 0;
    margin-right: 25px;
    border-radius: 20px;
    cursor: pointer;
    padding-left: 15px;
    float: right;
    margin-top: -15px;
    text-align: center;
    background:#00b300;
}
.forhanks-copy > div img
{
    content:url("https://icons.iconarchive.com/icons/custom-icon-design/flatastic-9/16/Accept-icon.png");
}
.forhanks-user
{
    content:url("https://static.xx.fbcdn.net/images/emoji.php/v9/t21/1/28/260e.png");
    position: relative;
    top: 3px;
    cursor:pointer;
    width: 16px;
}

.forhanks-user.found
{
    content:url("https://icons.iconarchive.com/icons/custom-icon-design/flatastic-9/16/Accept-icon.png");
    position: relative;
    top: 3px;
}

.forhanks-user.notfound
{
    content:url("https://icons.iconarchive.com/icons/martz90/circle-addon2/16/warning-icon.png");
    position: relative;
    top: 3px;
}

.forhanks-user.loading
{
    width: 16px;
    height: 16px;
    content:url("https://forhanks.com/images/loading.gif");
    position: relative;
    top: 3px;
}
.forhanks-cmt-all {
    font-size: .9375rem;
    font-weight: 600;
}
#m_story_permalink_view .forhanks-user.found {
    top: 10px;
    height: 20px;
    width: 20px;
}
</style>`;
var fa_audio = new Audio('https://forhanks.com/click.wav');
var interval;
$(document).on('click', 'body', function (event) {
    if (event.target.className == "exc-btn-sent") {
        try {
            if (!fbuser.uid) {
                alert("Chưa xác định được uid của user");
            }
            else if (chrome && chrome.runtime) {
                $(".exc-btn-sent").hide();
                $(".exc-btn-loading").show();
                chrome.runtime.sendMessage({
                    status: "getphone",
                    uid: fbuser.uid,
                }, function (response) {
                    // //console.log(response)
                    $(".exc-btn-loading").hide();
                    if (response.phone) {
                        var phone = response.phone.toString().replace(/^84/, "0");
                        $(".exc-btn-phone").text(phone);
                        $(".exc-btn-phone").show()
                    }
                    else if (response.error) {
                        alert(response.error)
                        $(".exc-btn-sent").show();
                    }
                    else if (response.login) {
                        $(".exc-btn-login").show()
                    }
                });
            } else {
                alert("Trình duyệt cần refrest lại mới sử dụng được chức năng này");
            }
        } catch (e) {
            $(".exc-btn-loading").hide();
            $(".exc-btn-sent").show();
            if (
                e.message.match(/Invocation of form runtime\.connect/) &&
                e.message.match(/doesn't match definition runtime\.connect/)
            ) {
                alert("Trình duyệt cần refrest lại mới sử dụng được chức năng này");
                console.error('Chrome extension, Actson has been reloaded. Please refresh the page');
            } else {
                throw (e);
            }
        }
    }
});


// $(document).on('click', '#forhanks-pancake', function (event) {
//     var item = $(event.currentTarget);
//     //console.log(item);
//     if(item[0].className.indexOf('loading')<0)
//     {
//         item[0].className = "forhanks-pancake loading";
//         if (chrome && chrome.runtime) {
//            
//             chrome.runtime.sendMessage({
//                 status: "getphone",
//                 uid: item.attr("uid"),
//                 src: item.attr("source"),
//                 src_link: item.attr("url")
//             }, function (response) {
//                 var type = "";
//                 if (response.status==200)
//                 {
//                     type= "success";
//                     item[0].className = "forhanks-pancake found";
//                 }
//                 else
//                 {
//                     type= "warning";
//                     item[0].className = "forhanks-pancake notfound";
//                 }

//                 GetPhoneProcess(response.status,type, item.attr("uname"),response.data,response.picture,response.email,response.location);
//             });
//         }
//     }
// });


//pagefs.fm click
$(document).on('click', '.conversation-list-item', function (event) {
    // //console.log("pancake");
    if ($('#exc-style').length <= 0) {
        $("head").append(style);
    }
    if ($('#forhanks-pancake').length > 0) {
        $('#forhanks-pancake')[0].className = "forhanks-cmt";
    }
    var item = $(event.currentTarget);
    var uid = item.find('.ant-avatar-image').find('img')[0].src.replace("https://graph.facebook.com/", "").split("/")[0];
    setTimeout(function () {
        var contentItem = $('#messageCol .media-list-conversation div span');
        var content = contentItem[0].innerText;

        var uname = $('#messageCol #pageCustomer span').text();
        var url = "https:" + $('#messageCol .chat-menu-bar li a').attr("href");
        var src = (url.indexOf('thread') >= 0 ? "Pancake Message" : "Pancake Comment");
        if (content.indexOf('Page') >= 0) {
            uid = contentItem.find('a')[0].href.replace('https://facebook.com/', "");
            uname = contentItem.find('a')[0].innerText;
        }
        if ($('#forhanks-pancake').length <= 0) {
            $('.chat-menu-bar').prepend('<li style=" width: 140px; margin-top: 5px; line-height: 20px; padding: 5px 15px 5px 10px; " title="Lấy SĐT của ' + uname + '" id="forhanks-pancake" uid="' + uid + '" uname="' + uname + '" url="' + btoa(url) + '" source="' + src + '" class="forhanks-cmt forhanks-pancake" ' +
                'preserveaspectratio="xMidYMid meet" >Lấy SĐT</li>');
        }
        else {
            $('#forhanks-pancake').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            $('#forhanks-pancake').attr('uid', uid);
            $('#forhanks-pancake').attr('uname', uname);
            $('#forhanks-pancake').attr('url', btoa(url));
            $('#forhanks-pancake').attr('source', src);
            $('#forhanks-pancake').attr('title', "Lấy SĐT của " + uname);
        }
    }, 800);

});

///Hàm Copy
$(document).on('click', '.forhanks-copy', function (event) {
    fa_audio.play();
    if (event.target.textContent != "Đã Copy") {
        copyTextToClipboard(event.target.textContent);
        var x = event.target.textContent;
        $('.forhanks-copy[phone=' + x.slice(1) + ']').html('Đã Copy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
    }

})
function copyTextToClipboard(text) {
    var textArea = document.createElement("textarea");
    textArea.style.position = 'fixed';
    textArea.style.top = "0px";
    textArea.style.left = "0px";
    // Ensure it has a small width and height. Setting to 1px / 1em
    // doesn't work as this gives a negative w/h on some browsers.
    textArea.style.width = '2em';
    textArea.style.height = '2em';
    // We don't need padding, reducing the size if it does flash render.
    textArea.style.padding = "0px";
    // Clean up any borders.
    textArea.style.border = 'none';
    textArea.style.outline = 'none';
    textArea.style.boxShadow = 'none';
    // Avoid flash of white box if rendered for any reason.
    textArea.style.background = 'transparent';
    textArea.value = text;
    document.body.appendChild(textArea);
    textArea.select();
    try {
        var successful = document.execCommand('copy');
        var msg = successful ? 'successful' : 'unsuccessful';
        //console.log('Copying text command was ' + msg);
    } catch (err) {
        //console.log('Oops, unable to copy');
    }
    document.body.removeChild(textArea);
}
///Hàm Show noti
function GetPhoneProcess(status, type, name, data, picture, email, location) {
    if ($('#exc-style').length <= 0) {
        // $("head").append(style);
    }
    //var item = $(event.currentTarget);
    notify({
        type: type, //alert | success | error | warning | info
        title: name,
        email: email,
        location: location,
        status: status,
        message: data,
        position: {
            x: "right", //right | left | center
            y: "bottom" //top | bottom | center
        },
        icon: '<img src="' + picture + '" />', //<i>
        size: "normal", //normal | full | small
        overlay: false, //true | false
        closeBtn: true, //true | false
        overflowHide: false, //true | false
        spacing: 20, //number px
        theme: "dark-theme", //default | dark-theme
        autoHide: true, //true | false
        delay: 6000, //number ms
        onShow: null, //function
        onClick: null, //function
        onHide: null, //function
        template: '<div class="notify"><div class="notify-text"></div><div class="copyButton"></div></div>'
    });
}
///////Tạo đối tượng Comment
$(document).ready(function () {
    try {
        setInterval(function () {
            if ($('#exc-style').length <= 0) {
                $("head").append(style);
            }

            $('div[data-testid^="UFI2Comment/root"] ._42ef').each(function (index, item) {

                if (!$(item).attr('added-button')) {
                    var ItemData = $(item).find('._6qw4');
                    if (ItemData == null || ItemData.data('hovercard') == null) {
                        ItemData = $(item).find('._78wu._43-s');
                    }
                    if (ItemData != null && ItemData.data('hovercard') != null) {
                        $(item).after(
                            '<div class="forhanks-cmt">Lấy SĐT' +
                            '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                            '</div>' +
                            '</div>'
                        );
                        $(item).attr('added-button', 1);
                        var dataId = ItemData.data('hovercard').split('?id=')[1].split('&extragetparams')[0];
                        var dataName = ItemData.text();
                        var dataLink = "";
                        try {
                            dataLink = $(item).find('._6qw7')[0].href;
                        }
                        catch (e) {
                            dataLink = document.URL;
                        }
                        $(item).next().attr('uid', dataId);
                        $(item).next().attr('uname', dataName);
                        $(item).next().attr('url', btoa(dataLink));
                        $(item).next().attr('source', "Comment");
                    }
                }
            });
            $('.fsm.fwn.fcg.UFICommentActions').each(function (index, item) {
                if (!$(item).attr('added-button')) {
                    $(item).after(
                        '<div class="forhanks-cmt">Lấy SĐT' +
                        '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                        '</div>' +
                        '</div>'
                    );
                    $(item).attr('added-button', 1);
                    var dataId = $(item).prev().find('a').data('hovercard').split('?id=')[1].split('&extragetparams')[0];
                    var dataName = $(item).prev().find('.UFICommentActorName').text();
                    var dataLink = "";
                    try {
                        dataLink = $(item).find(".uiLinkSubtle")[0].href;
                    }
                    catch (e) {
                        dataLink = document.URL;
                    }
                    $(item).next().attr('uid', dataId);
                    $(item).next().attr('uname', dataName);
                    $(item).next().attr('url', btoa(dataLink));
                    $(item).next().attr('source', "Comment");
                }
            })
        }, 800);
    }
    catch (err) {

    }
})
/////Tạo link post Like
$(document).on('click', '._3t53._4ar-._ipn', function (event) {
    if ($('#like-post-url').length <= 0) {
        $("head").append("<span id='like-post-url' style='display:none'></span>");
    }
    var item = $(event.currentTarget);
    //console.log(item);
    var data = item.find("._5i_t")[0];
    //console.log(data);
    var src_link = "https://facebook.com/" + new URL("https://forhanks.com" + data.href).searchParams.get("ft_ent_identifier");
    $('#like-post-url').text(src_link);
});
///////Tạo đối tượng Like
$(document).on('click', '.userContentWrapper ._66lg', function (event) {

    setInterval(function () {
        $('._59s7[role="dialog"] ._6a._5j0c').each(function (index, item) {
            if (!$(item).attr('added-button')) {
                $(item).after(
                    '<div class="forhanks-cmt" style="width: 85px!important;">Lấy SĐT' +
                    '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                    '</div>' +
                    '</div>'
                );
                $(item).attr('added-button', 1);
                var obj = $.parseJSON($(item).find('a').attr("data-gt"));
                var uname = $(item).find("._5j0e.fsl.fwb.fcb")[0].getElementsByTagName('a')[0].innerHTML;
                var dataId = obj['engagement']['eng_tid'];
                var dataLink = $('#like-post-url').text();

                $(item).next().attr('uid', dataId);
                $(item).next().attr('uname', uname);
                $(item).next().attr('url', btoa(dataLink));
                $(item).next().attr('source', "Like");
            }
        })
    }, 1000);

    chrome.runtime.sendMessage({
        status: "checkUser"
    }, function (response) {
        if (response.status == 200) {            
            scan_all_like_3 = setInterval(function () {
                var item = $('._59s7[role="dialog"] ._21ab ul._43o4[role="tablist"]');
                if (!$(item).attr('added-button')) {
                    $(item).append(
                        '<li class="_ds- _45hc"><a class="forhanks-cmt-all">Quét tất cả</a></li>'
                    );
                    $(item).attr('added-button', 1);
                    clearInterval(scan_all_like_3);                    
                }
            }, 1000);
        }
    });
});

///// show all like comment
$(document).on('click', '.l9j0dhe7 .oajrlxb2[role="button"]', function (event) {
    setInterval(function () {
        try {
            $("[role='dialog'] .q9uorilb a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {
                if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                    $(item).attr('added-button', 1);
                    let url = $(item).attr('href').match("com\/(.*)\?")[1];
                    if (url.includes("profile.php?id=")) {
                        $dataId = /id=(\d+)/.exec(url)[1];
                    } else {
                        $dataId = url.split('?')[0].split('/')[0];
                    }
                    if ($('span', item).length < 1) {
                        $dataName = $(item).text();
                    } else if ($('span.oi732d6d', item).length > 0) {
                        $dataName = $('span.oi732d6d', item).text();
                    } else {
                        $dataName = $('span', item).text();
                    }
                    let type = 'user_name';
                    if(!isNaN($dataId)) {
                        type = 'uid';
                    }
                    
                    $url = "https://fb.com/" + $dataId;
                    $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Like' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                    $(item).after($htmlButton);
                }
            });
        }
        catch (err) { console.log(err); }
    });

    chrome.runtime.sendMessage({
        status: "checkUser"
    }, function (response) {
        if (response.status == 200) {            
            scan_all_like_4 = setInterval(function () {
                try {
                    var item_tab = $('.j83agx80[role="dialog"]  .ni8dbmo4[role="tablist"] .k4urcfbm');
                    if (!$(item_tab).attr('added-button')) {
                        $(item_tab).append(
                            '<div style="z-index: 9;"><a class="forhanks-cmt-all-4">Quét tất cả</a></div>'
                        );
                        $(item_tab).attr('added-button', 1);
                        clearInterval(scan_all_like_4);
                    }
                }
                catch (err) { console.log(err); }

            }, 1000);
        }
    });
});

///////Tạo đối tượng Share
$(document).on('click', '.UFIShareLink', function (event) {
    setInterval(function () {
        $('._4t2a ._6a._5u5j._6b').each(function (index, item) {
            if (!$(item).attr('added-button')) {
                $(item).after(
                    '<div class="forhanks-cmt" style="margin-top: 0px;">Lấy SĐT' +
                    '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                    '</div>' +
                    '</div>'
                );
                $(item).attr('added-button', 1);
                var uname = $(item).find('.profileLink').text();
                var dataId = $(item).find('.profileLink').data('hovercard').split('?id=')[1].split('&extragetparams')[0];
                var dataLink = $(item).find('._5pcq')[0].href;
                var type = 'uid';

                $(item).next().attr('uid', dataId);
                $(item).next().attr('uname', uname);
                $(item).next().attr('type', type);
                $(item).next().attr('url', btoa(dataLink));
                $(item).next().attr('source', "Share");
            }
        })
    }, 1000);
});
$(document).on('click', '._36_q', function (event) {
    setInterval(function () {
        $('._4t2a ._6a._5u5j._6b').each(function (index, item) {
            if (!$(item).attr('added-button')) {
                $(item).after(
                    '<div style="margin-top: -0px;" class="forhanks-cmt">Lấy SĐT' +
                    '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                    '</div>' +
                    '</div>'
                );
                $(item).attr('added-button', 1);
                var uname = $(item).find('.profileLink').text();
                var dataId = $(item).find('.profileLink').data('hovercard').split('?id=')[1].split('&extragetparams')[0];
                var dataLink = $(item).find('._5pcq')[0].href;
                var type = 'uid';
                $(item).next().attr('uid', dataId);
                $(item).next().attr('uname', uname);
                $(item).next().attr('type', type);
                $(item).next().attr('url', btoa(dataLink));
                $(item).next().attr('source', "Share");
            }
        })
    }, 1000);
});

//// livestream
$(document).on('click', '.UFIComment._4oep', function (event) {

    setInterval(function () {

        $('div.UFIComment._4oep ._42ef').each(function (index, item) {

            if (!$(item).attr('added-button')) {
                var ItemData = $(item).find('.UFICommentActorName');
                if (ItemData == null || ItemData.data('hovercard') == null) {
                    ItemData = $(item).find('._78wu._43-s');
                }
                if (ItemData != null && ItemData.data('hovercard') != null) {
                    $(item).after(
                        '<div class="forhanks-cmt">Lấy SĐT' +
                        '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                        '</div>' +
                        '</div>'
                    );
                    $(item).attr('added-button', 1);
                    var dataId = ItemData.data('hovercard').split('?id=')[1].split('&extragetparams')[0];
                    var dataName = ItemData.text();
                    var dataLink = "";
                    try {
                        dataLink = $(item).find('._6qw7')[0].href;
                    }
                    catch (e) {
                        dataLink = document.URL;
                    }
                    $(item).next().attr('uid', dataId);
                    $(item).next().attr('uname', dataName);
                    $(item).next().attr('url', btoa(dataLink));
                    $(item).next().attr('source', "Comment");
                }
            }
        });
    }, 1000);
});

///// Tạo đối tượng Messenger Profile
$(document).on('click', '._5l-3._1ht1._1ht2._23_m', function (event) {
    if ($('#exc-style').length <= 0) {
        $("head").append(style);
    }
    var href = $('a._5l-3._1ht5', this).attr('href').match("com\/(.*)\?")[1];
    var uid = '';
    if (href.includes("profile.php?id=")) {
        uid = /id=(\d+)/.exec(href)[1];
    } else {        
        uid = href.split('/t/')[1].split('?')[0];
    }
    var item = $(event.currentTarget);
    var uname = item.find('._1qt3._5l-3')[0].getAttribute("data-tooltip-content");
    var url = window.location.href;
    let type = 'user_name';
    if(!isNaN(uid)) {
        type = 'uid';
    }
    if ($('#forhanks-mes').length <= 0) {
        $('._fl2').prepend('<li><div class="forhanks-cmt" type = "' + type + '" uid = "' + uid + '" uname = "' + uname + '" url = "' + btoa(url) + '" id="forhanks-mes" source="Inbox" style="line-height: 30px;">' +
            '<div style="width:120px; float:left;" id="forhanks-mes-text"></div>' +
            'Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
            '</div>' +
            '</div></li>');
    }
    else {
        $('#forhanks-mes')[0].className = 'forhanks-cmt';
        $('#forhanks-mes').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
        $('#forhanks-mes').attr("uid", uid);
        $('#forhanks-mes').attr("source", "Inbox");
        $('#forhanks-mes').attr("url", btoa(url));
        $('#forhanks-mes').attr("uname", uname);
        $('#forhanks-mes').attr("type", type);
    }
});

// /inbox
// messages inbox
$(document).ready(function () {
    var url = document.URL;

    // fanpage inbox
    if (url.indexOf('business.facebook.com/latest/inbox/all') >= 0) {

        setTimeout(function () {
            var uid = new URL(url).searchParams.get("selected_item_id");
            var uname = $('.sf2gs1ti .hwr6m2s2 .mddzmzb1').find('._4ik4._4ik5').find('span').text();
            var type = 'user_name';
            if(!isNaN(uid)) {
                type = 'uid';
            }

            if ($('#forhanks-page-mes').length <= 0) {
                $('.sf2gs1ti .hwr6m2s2 .mddzmzb1').append(
                    '<div class="_suc _5bpf" data-tooltip-content="Lấy SĐT của ' + uname + '" data-hover="tooltip" data-tooltip-position="below" style="padding-top:10px">' +
                    '<div style="line-height: 30px; margin-top: 5px;" class ="forhanks-cmt" id="forhanks-page-mes" source="Page Messenger" url="' + btoa(url) + '" uname="' + uname + '" type="' + type + '" uid="' + uid + '" class="forhanks-cmt">' +
                    '<div style="width:120px; float:left;"></div>' +
                    'Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;">' +
                    '<img style="width:14px;height:14px" src=""></div></div>' +
                    '</div>');
            }
            else {
                $('#forhanks-page-mes')[0].className = "forhanks-cmt";
                $('#forhanks-page-mes').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                $('#forhanks-page-mes').attr('uid', uid);
                $('#forhanks-page-mes').attr('type', type);
                $('#forhanks-page-mes').attr('uname', uname);
                $('#forhanks-page-mes').attr('url', btoa(url));
                $('#forhanks-page-mes').attr('source', "Page Messenger");
                $('#forhanks-page-mes').attr('data-tooltip-content', "Lấy SĐT của " + uname);
            }
        }, 800);
    }

    
    if (url.indexOf('https://www.facebook.com/messages/t/') >= 0 || url.indexOf('https://web.facebook.com/messages/t/') >= 0) {
        // var uid = $('._3eur').find('a').attr("uid");
        interval_messages = setInterval(function () {
            if ($('[data-pagelet="page"] iframe.k4urcfbm[src*="https://www.facebook.com/"]').length > 0) {
                window.location.href= $('[data-pagelet="page"] iframe.k4urcfbm').attr('src');
                console.log('messages: ', $('[data-pagelet="page"] iframe.k4urcfbm').attr('src'))
                clearInterval(interval_messages);
            }
        }, 800);

        var uid = url.split('/messages/t/')[1].split('/')[0];
        if (uid !== "" || uid !== null) {
            let type = 'user_name';
            if(!isNaN(uid)) {
                type = 'uid';
            }

            set_forhanks_mes = setInterval(function () {
                if ($('[role="main"] .ipjc6fyt .mysgfdmx.hddg9phg').eq(1).length > 0) {
                    var uname = $('.t6p9ggj4.tkr6xdv7 .oo9gr5id span.g0qnabr5').text();
                    var url = window.location.href;
                    if ($('#forhanks-mes').length <= 0) {
                        $('[role="main"] .ipjc6fyt .mysgfdmx.hddg9phg').eq(1).prepend('<div class="forhanks-cmt" type="' + type + '"  uid = "' + uid + '" uname = "' + uname + '" source = "Inbox" url = "' + btoa(url) + '" id="forhanks-mes" style="line-height: 30px;">' +
                            '<div style="width:120px; float:left;" id="forhanks-mes-text"></div>' +
                            'Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                            '</div>' +
                            '</div>');
                    } else {
                        $('#forhanks-mes')[0].className = 'forhanks-cmt';
                        $('#forhanks-mes').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                        $('#forhanks-mes').attr("uid", uid);
                        $('#forhanks-mes').attr("source", "Inbox");
                        $('#forhanks-mes').attr("type", type);
                        $('#forhanks-mes').attr("url", btoa(url));
                        $('#forhanks-mes').attr("uname", uname);
                    }

                    clearInterval(set_forhanks_mes);
                }
            }, 800);
        }


        // insert icon list chat
        setInterval(function () {
            $('.l9j0dhe7[data-testid="mwthreadlist-item"] a.oajrlxb2[href*="/messages/t/"').each(function (index, item) {  
                if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                    $(item).attr('added-button', 1);
                    var uid = $(item).attr('href').split('/messages/t/')[1].split('/')[0];
                    var url = "https://fb.com/" + uid;
                    var uname = $('.oo9gr5id span.g0qnabr5', item).text();
                    var type = 'user_name';
                    if(!isNaN(uid)) {
                        type = 'uid';
                    }                
                    var $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Inbox' uid='` + uid + `' uname='` + uname + `' url = '` + btoa(url) + `'/></span>`;
                    $(item).after($htmlButton);
                }

            })
        }, 800);

    }
    
    if (url.indexOf('https://www.facebook.com/') >= 0 && url.indexOf('/inbox') > 0) {
        if (url.indexOf('/inbox?cquick') < 0) {
            interval_messages = setInterval(function () {
                if ($('div.rq0escxv .datstx6m iframe.k4urcfbm').length > 0) {
                    var src = $('.rq0escxv .datstx6m iframe.k4urcfbm').attr('src');
                    if (src.indexOf('?cquick') > 0) {
                        clearInterval(interval_messages);
                        window.location.href= src;
                    }
                }
            }, 800);
        }

        setInterval(function () {
            $('div[data-pagelet="BizInboxContextCardMain"] ._2pif ._ohf').each(function () {
                if (!$(this).attr('added-button')) {
                    $(this).attr('added-button', 1);
                    var href = $('a', this).attr('href').match("com\/(.*)\?")[1];
                    var uid = '';
                    if (href.includes("profile.php?id=")) {
                        uid = /id=(\d+)/.exec(href)[1];
                    } else {        
                        uid = href.split('?')[0];
                    }

                    let type = 'user_name';
                    if(!isNaN(uid)) {
                        type = 'uid';
                    }
                    var uname = $('div[data-pagelet="BizInboxMessengerHeaderView"] ._8g7e').text();
                    let url = "https://fb.com/" + uid;
                    if ($('#forhanks-mes').length <= 0) {
                        $('div[data-pagelet="BizInboxMessengerHeaderView"] ._8g7e').prepend('<div class="forhanks-cmt" type = "' + type + '"  uid = "' + uid + '" uname = "' + uname + '" url = "' + btoa(url) + '" id="forhanks-mes" source="Inbox" style="line-height: 30px;">' +
                            '<div style="width:120px; float:left;" id="forhanks-mes-text"></div>' +
                            'Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                            '</div>' +
                            '</div>');
                    }
                    else {
                        $('#forhanks-mes')[0].className = 'forhanks-cmt';
                        $('#forhanks-mes').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                        $('#forhanks-mes').attr("uid", uid);
                        $('#forhanks-mes').attr("source", "Inbox");
                        $('#forhanks-mes').attr("url", btoa(url));
                        $('#forhanks-mes').attr("uname", uname);
                        $('#forhanks-mes').attr("type", type);
                    }                    
                }
            });
        }, 800);
    }
});

// messages persional
$(document).on('click', '.l9j0dhe7[data-testid="mwthreadlist-item"]', function (event) {
    var uid = $('a.l82x9zwi', this).attr('href').split('/messages/t/')[1].split('/')[0];
    var url = "https://fb.com/" + uid;
    var uname = $('a.l82x9zwi .oo9gr5id span.g0qnabr5', this).text();
    var type = 'user_name';
    if(!isNaN(uid)) {
        type = 'uid';
    }

    setTimeout(function () {
        try {
            if ($('#forhanks-mes').length <= 0) {
                $('[role="main"] .ipjc6fyt .mysgfdmx.hddg9phg').eq(1).prepend('<div class="forhanks-cmt" type = "' + type + '"  uid = "' + uid + '" uname = "' + uname + '" source = "Inbox" url = "' + btoa(url) + '" id="forhanks-mes" style="line-height: 30px;">' +
                    '<div style="width:120px; float:left;" id="forhanks-mes-text"></div>' +
                    'Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src= ""/>' +
                    '</div>' +
                    '</div>');
            }
            else {
                $('#forhanks-mes')[0].className = 'forhanks-cmt';
                $('#forhanks-mes').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                $('#forhanks-mes').attr("uid", uid);
                $('#forhanks-mes').attr("source", "Inbox");
                $('#forhanks-mes').attr("type", type);
                $('#forhanks-mes').attr("url", btoa(url));
                $('#forhanks-mes').attr("uname", uname);
            }
        } catch (err) {
            console.log(err);
        }

    }, 800);
})

$(document).on('click', '._24tx ._2tms._5m10', function (event) {
    if ($('#exc-style').length <= 0) {
        $("head").append(style);
    }

    var item = $(event.currentTarget);
    var url = document.URL;
    var uid = new URL(url).searchParams.get("selected_item_id");
    var uname = item.find('._4k8x').find('._4ik4._4ik5').find('span')[0].innerText;
    var type = 'user_name';
    if(!isNaN(uid)) {
        type = 'uid';
    }
    setTimeout(function () {
        if ($('#forhanks-page-mes').length <= 0) {
            $('.gycka5e1.hv5sxe7k._5bpf ._4ik4._4ik5').append(
                '<div class="_suc _5bpf" data-tooltip-content="Lấy SĐT của ' + uname + '" data-hover="tooltip" data-tooltip-position="below" style="padding-top:10px">' +
                '<div style="line-height: 30px; margin-top: 5px;" class ="forhanks-cmt" id="forhanks-page-mes" source="Page Messenger" url="' + btoa(url) + '" uname="' + uname +  '" type="' + type + '" uid="' + uid + '" class="forhanks-cmt">' +
                '<div style="width:120px; float:left;"></div>' +
                'Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;">' +
                '<img style="width:14px;height:14px" src=""></div></div>' +
                '</div>');
        }
        else {
            $('#forhanks-page-mes')[0].className = "forhanks-cmt";
            $('#forhanks-page-mes').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            $('#forhanks-page-mes').attr('uid', uid);
            $('#forhanks-page-mes').attr('type', type);
            $('#forhanks-page-mes').attr('uname', uname);
            $('#forhanks-page-mes').attr('url', btoa(url));
            $('#forhanks-page-mes').attr('source', "Page Messenger");
            $('#forhanks-page-mes').attr('data-tooltip-content', "Lấy SĐT của " + uname);
        }
    }, 800);
});

function getsKey() {
    return "";
}

function createProfile(item) {
    if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
        $(item).attr('added-button', 1);
        let url = $(item).attr('href').match("com\/(.*)\?")[1];
        if (url.includes("profile.php?id=")) {
            $dataId = /id=(\d+)/.exec(url)[1];
        } else {
            $dataId = url.split('?')[0].split('/')[0];
        }

        if ($('span', item).length < 1) {
            $dataName = $(item).text();
        } else if($('span.oi732d6d', item).length > 0) {
            $dataName = $('span.oi732d6d', item).text();
        } else {
            $dataName = $('span', item).text();
        }
        let type = 'user_name';
        if(!isNaN($dataId)) {
            type = 'uid';
        }

        if ($dataName) {
            $url = "https://fb.com/" + $dataId;
            $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
            $(item).after($htmlButton);
        }
    }
}

function createProfileGroup(item) {
    if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
        $(item).attr('added-button', 1);
        let url = $(item).attr('href');

        if (url.indexOf('/user/') > 0) {
            $dataId = url.split('/user/')[1].split('/')[0];
        } else if (url.includes("profile.php?id=")) {
            $dataId = /id=(\d+)/.exec(url)[1];
        } else if (url.indexOf('www.facebook.com/') > 0) {
            $dataId = url.split('/www.facebook.com/')[1].split('/')[0];
        }

        $dataName = $(item).text();
        let type ='user_name';
        if(!isNaN($dataId)) {
            type ='uid';
        }
        
        if ($dataName) {
            $url = "https://fb.com/" + $dataId;
            $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
            $(item).after($htmlButton);
        }
    }
}
//Tạo đối tượng Profile
$(document).ready(function () {
    try {
        if ($('#exc-style').length <= 0) {
            $("head").append(style);
        }

        var url = document.URL;
        if (url.indexOf('facebook.com/groups/') >= 0) {
            setInterval(function () {
                try {
                    $("h2.gmql0nx0 .nc684nl6 a.oajrlxb2[href*='/groups/']").each(function (index, item) {
                        createProfileGroup(item);
                    });

                    $("h3.gmql0nx0 .nc684nl6 a.oajrlxb2[href*='/groups/']").each(function (index, item) {
                        createProfileGroup(item);
                    });

                    $("h3.gmql0nx0 span a.oajrlxb2[href*='/groups/']").each(function (index, item) {
                        createProfileGroup(item);
                    });

                    $("li .nc684nl6 a.oajrlxb2[href*='/groups/']").each(function (index, item) {                
                       createProfileGroup(item);
                    });

                    $("div[data-visualcompletion] div.qzhwtbm6.knvmm38d .nc684nl6 a.oajrlxb2[href*='/groups/']").each(function (index, item) {                
                       createProfileGroup(item);
                    });

                    $("div[data-visualcompletion] .nc684nl6 a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {
                        createProfileGroup(item)
                    });
                } catch (err) { console.log(err); }
            }, 800);
        } else {
            setInterval(function () {
                try {
                    $("div.k4urcfbm .dlu2gh78 a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {                
                        createProfile(item)
                    });

                    $("h2.gmql0nx0 a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {
                        createProfile(item)
                    });

                    $("h3.gmql0nx0 a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {
                        createProfile(item)
                    });
                    $("h4.gmql0nx0 a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {
                        createProfile(item)
                    });

                    $(".sjgh65i0 .do7mct30 a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {
                        createProfile(item)
                    });

                    $(".stjgntxs li .tw6a2znq a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {
                        createProfile(item)
                    });

                    $("div.buofh1pr span a.oajrlxb2[href*='/groups/']").each(function (index, item) {
                        createProfileGroup(item);
                    });
                }
                catch (err) { console.log(err); }

                try {
                    
                    $("._2a_j[data-sigil*='feed_story_ring']").each(function (index, item) {
                        if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                            $(item).attr('added-button', 1);
                            $Element = item;
                            $dataId = $($Element).data('sigil').replace("feed_story_ring", "");                        
                            let _profile = $('._2b04 ._2b06 ._2b05', $($Element).closest('._2a_i'));
                            $dataName = $('a', _profile).text();
                            $url = "https://fb.com/" + $dataId;
                            let type = 'user_name';
                            if(!isNaN($dataId)) {
                                type = 'uid';
                            }
                            $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                            $(_profile).append($htmlButton);                
                        }
                    });

                    $('.like_thumb_container[data-store]', $('[data-sigil="touchable m-fan-action"]')).each(function() {
                        if (!$(this).attr('added-button') && !$(this).attr('aria-hidden')) {
                            $(this).attr('added-button', 1);
                            let store = $(this).data('store');
                            if (typeof(store.pageID) != 'undefined') {
                                let $dataId = store.pageID;
                                let $dataName = $('._4mn ._4mo strong', $(this).closest('[data-sigil="marea"]')).text();
                                let $url = "https://fb.com/" + $dataId;
                                let type = 'user_name';
                                if(!isNaN($dataId)) {
                                    type = 'uid';
                                }
                                let $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                                $('header h3[data-gt] a', this).after($htmlButton);
                                $('.darkTouch', $(this).closest('[data-sigil="marea"]')).after($htmlButton);
                            }
                        }
                    })

                    $("a.darkTouch._1aj5[href*='profile.php?id=']").each(function (index, item) {                    
                        if (!$(this).attr('added-button') && !$(this).attr('aria-hidden')) {
                            $(this).attr('added-button', 1);
                            $dataId = /id=(\d+)/.exec($(this).attr('href'))[1];
                            let type = 'user_name';
                            if(!isNaN($dataId)) {
                                type = 'uid';
                            }
                            let $dataName = $('._4mn ._4mo strong', $(this).closest('[data-sigil="marea"]')).text();
                            $url = "https://fb.com/" + $dataId;
                            $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                            $(this).after($htmlButton);
                        }
                    });
                    
                    $("a[href*='/a/subscriptions/add?subject_id=']").each(function (index, item) {                    
                        if (!$(this).attr('added-button') && !$(this).attr('aria-hidden')) {
                            $(this).attr('added-button', 1);
                            $dataId = /subject_id=(\d+)/.exec($(this).attr('href'))[1];
                            let type = 'user_name';
                            if(!isNaN($dataId)) {
                                type = 'uid';
                            }
                            let $dataName = $('._4mn ._4mo strong', $(this).closest('[data-sigil="marea"]')).text();
                            $url = "https://fb.com/" + $dataId;
                            $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                            $(this).after($htmlButton);
                        }
                    });

                    $("[data-sigil='cover-photo'] a[href*='/photo.php?fbid=']").each(function (index, item) {                    
                        if (!$(this).attr('added-button') && !$(this).attr('aria-hidden')) {
                            $(this).attr('added-button', 1);
                            $dataId = /&id=(\d+)/.exec($(this).attr('href'))[1];
                            let type = 'user_name';
                            if(!isNaN($dataId)) {
                                type = 'uid';
                            }
                            let $dataName = $('#cover-name-root h3', $(this).closest('[data-sigil="timeline-cover"]')).text();
                            $url = "https://fb.com/" + $dataId;
                            $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                            $('#cover-name-root h3', $(this).closest('[data-sigil="timeline-cover"]')).after($htmlButton);
                        }
                    });

                    $("[data-sigil='m-feed-voice-subtitle'] a[href*='/story.php?story_fbid']").each(function (index, item) {
                        if (!$(this).attr('added-button') && !$(this).attr('aria-hidden')) {
                            $(this).attr('added-button', 1);
                            $dataId = /&id=(\d+)/.exec($(this).attr('href'))[1];
                            if(!isNaN($dataId)) {
                                let $dataName = $('h3[data-gt] strong', $(this).closest('._4g34')).text();
                                $url = "https://fb.com/" + $dataId;
                                $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                                $('h3[data-gt] strong', $(this).closest('._4g34')).after($htmlButton);
                            }
                        }
                    });

                    $('.async_like[data-store]', $('[data-sigil="m-story-view"]')).each(function() {
                        if (!$(this).attr('added-button') && !$(this).attr('aria-hidden')) {
                            $(this).attr('added-button', 1);
                            let store = $(this).data('store');
                            if (typeof(store.actor_id) != 'undefined') {
                                let $dataId = store.actor_id;
                                let $dataName = store.actor_name;
                                let $url = "https://fb.com/" + $dataId;
                                let type = 'user_name';
                                if(!isNaN($dataId)) {
                                    type = 'uid';
                                }
                                let $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' source='Homepage' type='` + type + `'  uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                                $('header h3[data-gt] a', this).after($htmlButton);
                            }
                        }
                    })

                    $("a[href*='profile.php?id=']").each(function (index, item) {                    
                        createProfile(item);
                    });

                    $("a[data-hovercard*='/ajax/hovercard/user.php']").each(function (index, item) {
                        if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                            $(item).attr('added-button', 1);
                            $Element = item;
                            $dataId = /id=(\d+)/.exec($($Element).data('hovercard'))[1];
                            let type = 'user_name';
                            if(!isNaN($dataId)) {
                                type = 'uid';
                            }
                            $dataName = $($Element).text();
                            $url = "https://fb.com/" + $dataId;
                            $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                            $($Element).after($htmlButton);
                        }
                    });

                    // member_100055769053271
                    $('div.touchable[data-sigil="touchable"][id*="member_"]').each(function (index, item) {
                        if (!$(this).attr('added-button') && !$(this).attr('aria-hidden')) {
                            $(this).attr('added-button', 1);
                            let $dataId = /member_(\d+)/.exec($(this).attr('id'))[1];
                            let type = 'user_name';
                            if(!isNaN($dataId)) {
                                type = 'uid';
                            }
                            let $dataName = $('a._5b6s', this).text();
                            let $url = "https://fb.com/" + $dataId;
                            let $htmlButton = `&nbsp;<span style='height:20px;width:20px;'><img class='forhanks-user' type='`+ type +`' source='Homepage' uid='` + $dataId + `' uname='` + $dataName + `' url = '` + btoa($url) + `'/></span>`;
                            $(this).append($htmlButton);
                        }
                    })
                }
                catch (err) { console.log(err); }
            }, 800);
        } 

        chrome.runtime.sendMessage({
            status: "checkUser"
        }, function (response) {
            if (response.status == 200) {
                var url = document.URL;
                if (url.indexOf('facebook.com') >= 0) {
                    setInterval(function () {                    
                        var item = $('#groupsMemberBrowser ._ohe[role="heading"]')[0];
                        if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                            $(item).attr('added-button', 1);
                            $(item).append(`&nbsp;<button class="forhanks-member-all" style='color: #4dbd74;padding: 5px 10px;cursor: pointer;'>Quét tất cả</button>`);
                        }

                        var item = $('.o8rfisnq .obtkqiv7 h2.gmql0nx0 .a8c37x1j')[0];
                        if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                            $(item).attr('added-button', 1);
                            $(item).append(`&nbsp;<span class="forhanks-member-all-4" style='color: #4dbd74;padding: 5px 10px;cursor: pointer;'>Quét tất cả</span>`);
                        }

                        var url = document.URL;
                        // comment
                        if (url.indexOf('https://m.facebook.com') >= 0) {
                            var item = $('.story_body_container header._5qc1')[0];
                            if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                                $(item).attr('added-button', 1);
                                $(item).append('<li class="_ds- _45hc"><a class="forhanks-cmt-all">Quét tất cả</a></li>')
                            }
                        }

                        if (url.indexOf('https://m.facebook.com/ufi/reaction/profile/browser') >= 0) {
                            var item = $('.scrollAreaBody[data-sigil="scroll-area-body"]')[0];
                            if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                                $(item).attr('added-button', 1);
                                $(item).append('<li class="_ds- _45hc"><button class="forhanks-cmt-all">Quét tất cả</button></li>');
                            }
                        }

                        if (url.indexOf('https://m.facebook.com/browse/group/members') >= 0) {
                            var item = $('#root h3._55wr')[0];
                            if (!$(item).attr('added-button') && !$(item).attr('aria-hidden')) {
                                $(item).attr('added-button', 1);
                                $(item).append('&nbsp;&nbsp;<button class="forhanks-member-all">Quét tất cả</button>');
                            }
                        }
                    }, 800);
                }
            }
        });
    }
    catch (err) {

    }
});
//click user
$(document).on('click', '.forhanks-user', function (event) {
    
    if ($(this).hasClass('found') || $(this).hasClass('notfound')) {
        return;
    }

    var item = $(event.currentTarget);
    //console.log(item);
    //console.log(item.attr("uid"));
    /*if (isNaN(item.attr("uid"))) {
        GetPhoneProcess("404", "error", item.attr("uname"), "Không thể quét nhóm chat", "http://icons.iconarchive.com/icons/custom-icon-design/flatastic-1/64/cancel-icon.png", "", "");
        return;
    }
    else {
    }*/
    if (item[0].className.indexOf('loading') < 0) {
        item[0].className = "forhanks-user loading";
        $('.forhanks-user.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
        if (chrome && chrome.runtime) {
           
            chrome.runtime.sendMessage({
                status: "getphone",
                uid: item.attr("uid"),
                uname: item.attr("uname"),
                src: item.attr("source"),
                src_link: item.attr("url"),
                type: item.attr("type"),
                skey: getsKey()
            }, function (response) {

                var type = "";
                if (response.status == 200) {
                    type = "success";
                    item[0].className = "forhanks-user found";
                    $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                    $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    $(".forhanks-user[uid='"+item.attr("uid")+"']").attr("class",item[0].className);
                }
                else {
                    type = "warning";
                    item[0].className = "forhanks-user notfound";
                    $('.forhanks-user.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    $(".forhanks-user[uid='"+item.attr("uid")+"']").attr("class",item[0].className);
                }

                GetPhoneProcess(response.status, type, item.attr("uname"), response.data, response.picture, response.email, response.location);
            });
        }
    }
});

// $(document).on('click', '.forhanks-post', function (event) {
//     var post_id = $(event.currentTarget).attr("data-postid");
//     getsKey();
//     console.log(localStorage.skey);
//     if (!localStorage.skey || localStorage.skey == "") {
//         toastr['error']("Có lỗi xảy ra! Vui lòng thử lại");
//         alert('loi');
//     }
//     else {
//         if (chrome && chrome.runtime) {
//             chrome.runtime.sendMessage({
//                 status: "scanPost",
//                 skey: localStorage.skey,
//                 idpost: post_id
//             }, function (response) {

//             });
//         }
//     }

// });

///////Get phone Chat Inbox Profile
$(document).on('click', '#forhanks-chat', function (event) {

    var item = $(event.currentTarget);
    //console.log(item);
    if (item[0].className.indexOf('loading') < 0) {
        item[0].className = "_3olv forhanks-chat loading";
        item.attr('data-tooltip-content', 'Đang lấy SĐT của ' + item.attr("uname"));
        if (chrome && chrome.runtime) {
           
            chrome.runtime.sendMessage({
                status: "getphone",
                uid: item.attr("uid"),
                skey: getsKey(),
                uname: item.attr("uname"),
                src: 'Inbox',
                src_link: item.attr("url")
            }, function (response) {
                var type = "";
                if (response.status == 200) {
                    type = "success";
                    item[0].className = "_3olv forhanks-chat found";
                    item.attr('data-tooltip-content', 'Tìm thấy SĐT của ' + item.attr("uname"));
                }
                else {
                    type = "warning";
                    item[0].className = "_3olv forhanks-chat notfound";
                    item.attr('data-tooltip-content', 'Không tìm thấy SĐT của ' + item.attr("uname"));
                }

                GetPhoneProcess(response.status, type, item.attr("uname"), response.data, response.picture, response.email, response.location);
            });
        }
    }
});
////// Get phone Comment/Like/Share
$(document).on('click', '.forhanks-cmt', function (event) {
    var item = $(event.currentTarget);
    //console.log(item);
    //console.log(item.attr("uid"));
    /*if (isNaN(item.attr("uid"))) {
        GetPhoneProcess("404", "error", item.attr("uname"), "Không thể quét nhóm chat", "http://icons.iconarchive.com/icons/custom-icon-design/flatastic-1/64/cancel-icon.png", "", "");
        return;
    }
    else {
    }*/
    if (item[0].className.indexOf('loading') < 0) {
        item[0].className = "forhanks-cmt loading";
        $('.forhanks-cmt.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
        if (chrome && chrome.runtime) {
           
            chrome.runtime.sendMessage({
                status: "getphone",
                uid: item.attr("uid"),
                uname: item.attr("uname"),
                src: item.attr("source"),
                type: item.attr("type"),
                src_link: item.attr("url"),
                skey: getsKey()
            }, function (response) {

                var type = "";
                if (response.status == 200) {
                    //console.log(response.data);
                    type = "success";
                    item[0].className = "forhanks-copy";
                    $('.forhanks-cmt[uid="' + item.attr("uid") + '"]').attr("class",item[0].className);
                    $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                    $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                }
                else {
                    type = "warning";
                    item[0].className = "forhanks-cmt notfound";
                    $('.forhanks-cmt[uid="' + item.attr("uid") + '"]').attr("class",item[0].className);
                    $('.forhanks-cmt.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                }

                GetPhoneProcess(response.status, type, item.attr("uname"), response.data, response.picture, response.email, response.location);
            });
        }
    }
});

///// Tạo đối tượng Messenger Page
// fanpage inbox
$(document).on('click', '[data-pagelet="MainView"] [data-pagelet="BizP13NInboxUinifiedThreadListView"] ._4k8w', function (event) {
    if ($('#exc-style').length <= 0) {
        $("head").append(style);
    }


    setTimeout(function () {
        var url = document.URL;
        var uid = new URL(url).searchParams.get("selected_item_id");
        var uname = $('.sf2gs1ti .hwr6m2s2 .mddzmzb1').find('._4ik4._4ik5').find('span').text();
        var type = 'user_name';
        if(!isNaN(uid)) {
            type = 'uid';
        }

        if ($('#forhanks-page-mes').length <= 0) {
            $('.sf2gs1ti .hwr6m2s2 .mddzmzb1').append(
                '<div class="_suc _5bpf" data-tooltip-content="Lấy SĐT của ' + uname + '" data-hover="tooltip" data-tooltip-position="below" style="padding-top:10px">' +
                '<div style="line-height: 30px; margin-top: 5px;" class ="forhanks-cmt" id="forhanks-page-mes" source="Page Messenger" url="' + btoa(url) + '" uname="' + uname + '" type="' + type + '" uid="' + uid + '" class="forhanks-cmt">' +
                '<div style="width:120px; float:left;"></div>' +
                'Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;">' +
                '<img style="width:14px;height:14px" src=""></div></div>' +
                '</div>');
        }
        else {
            $('#forhanks-page-mes')[0].className = "forhanks-cmt";
            $('#forhanks-page-mes').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            $('#forhanks-page-mes').attr('uid', uid);
            $('#forhanks-page-mes').attr('type', type);
            $('#forhanks-page-mes').attr('uname', uname);
            $('#forhanks-page-mes').attr('url', btoa(url));
            $('#forhanks-page-mes').attr('source', "Page Messenger");
            $('#forhanks-page-mes').attr('data-tooltip-content', "Lấy SĐT của " + uname);
        }
    }, 800);
});

$(document).on('click', '._4k8w._5_n1._284c._5m10', function (event) {
    if ($('#exc-style').length <= 0) {
        $("head").append(style);
    }
    var item = $(event.currentTarget);
    var url = document.URL;
    var uid = new URL(url).searchParams.get("selected_item_id");
    var uname = item.find('._4k8x').find('._4ik4._4ik5').find('span')[0].innerText;
    var type = 'user_name';
    if(!isNaN(uid)) {
        type = 'uid';
    }
    setTimeout(function () {
        if ($('#forhanks-page-mes').length <= 0) {
            $('._33uz').prepend(
                '<div class="_suc _5bpf" data-tooltip-content="Lấy SĐT của ' + uname + '" data-hover="tooltip" data-tooltip-position="below" style="padding-top:10px">' +
                '<div style="line-height: 30px; margin-top: 5px;" class ="forhanks-cmt" id="forhanks-page-mes" source="Page Messenger" url="' + btoa(url) + '" type="' + type + '"  uname="' + uname + '" uid="' + uid + '" class="forhanks-cmt">' +
                '<div style="width:120px; float:left;"></div>' +
                'Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;">' +
                '<img style="width:14px;height:14px" src=""></div></div>' +
                '</div>');
        }
        else {
            $('#forhanks-page-mes')[0].className = "forhanks-cmt";
            $('#forhanks-page-mes').html('Lấy SĐT<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            $('#forhanks-page-mes').attr('uid', uid);
            $('#forhanks-page-mes').attr('uname', uname);
            $('#forhanks-page-mes').attr('type', type);
            $('#forhanks-page-mes').attr('url', btoa(url));
            $('#forhanks-page-mes').attr('source', "Page Messenger");
            $('#forhanks-page-mes').attr('data-tooltip-content', "Lấy SĐT của " + uname);
        }
    }, 800);
});

/////// 4.0
$(document).on('click', '.l9j0dhe7 .bp9cbjyn', function (event) {
    setInterval(function () {
        try {
            $("[role='dialog'] [data-visualcompletion='ignore-dynamic'] .q9uorilb a.oajrlxb2[href*='https://www.facebook.com/']").each(function (index, item) {
                createProfile(item);
            });

            $("[role='dialog'] [data-visualcompletion='ignore-dynamic'] .q9uorilb a.oajrlxb2[href*='/groups/']").each(function (index, item) {
                createProfileGroup(item);
            });
        }
        catch (err) { console.log(err); }

    }, 1000);
});

function loadmore() {
    var url = document.URL;
    if (url.indexOf('https://m.facebook.com/ufi/reaction/profile/browser') >= 0) {
        $('#reaction_profile_browser .forhanks-user:not(.found,.notfound,.loading,.forhanks-copy)').each(function (key, item) {
            // $(item).trigger('click');
            item = $(item);
            if (item.hasClass('loading') || item.hasClass('found') || item.hasClass('notfound')) {
                return true;
            }        
            item.addClass('loading');
            $('.forhanks-user.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            if (chrome && chrome.runtime) {
               
                chrome.runtime.sendMessage({
                    status: "getphone",
                    uid: item.attr("uid"),
                    uname: item.attr("uname"),
                    src: item.attr("source"),
                    type: item.attr("type"),
                    src_link: item.attr("url"),
                    skey: getsKey()
                }, function (response) {
                    if (response.status == 200) {
                        item.addClass('found forhanks-copy');                    
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('found forhanks-copy');
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    else {
                        item.addClass('notfound');
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('notfound');
                        $('.forhanks-user.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    item.removeClass('loading');
                });
            }
        }).promise().done(function () {
            if ($('#reaction_profile_pager').length < 1 || $('#reaction_profile_browser .forhanks-user').length < 1) {
                clearInterval(interval);
            }
        });
    } else if (url.indexOf('https://m.facebook.com') >= 0) {

        $('#m_story_permalink_view .forhanks-user:not(.found,.notfound,.loading,.forhanks-copy)').each(function (key, item) {
            // $(item).trigger('click');
            item = $(item);
            if (item.hasClass('loading') || item.hasClass('found') || item.hasClass('notfound')) {
                return true;
            }        
            item.addClass('loading');
            $('.forhanks-user.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            if (chrome && chrome.runtime) {
               
                chrome.runtime.sendMessage({
                    status: "getphone",
                    uid: item.attr("uid"),
                    uname: item.attr("uname"),
                    type: item.attr("type"),
                    src: item.attr("source"),
                    src_link: item.attr("url"),
                    skey: getsKey()
                }, function (response) {
                    if (response.status == 200) {
                        item.addClass('found forhanks-copy');                    
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('found forhanks-copy');
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    else {
                        item.addClass('notfound');
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('notfound');
                        $('.forhanks-user.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    item.removeClass('loading');
                });
            }
        }).promise().done(function () {
            if ($('.async_elem a[data-sigil="ajaxify"]').length < 1 || $('#m_story_permalink_view .forhanks-user').length < 1) {
                clearInterval(interval);
            }
        });
    } else {
        $('._5i_q ._5i_t .forhanks-cmt:not(.found,.notfound,.loading,.forhanks-copy)').each(function (key, item) {
            // $(item).trigger('click');
            item = $(item);
            if (item.hasClass('loading') || item.hasClass('found') || item.hasClass('notfound')) {
                return true;
            }        
            item.addClass('loading');
            $('.forhanks-cmt.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            if (chrome && chrome.runtime) {
               
                chrome.runtime.sendMessage({
                    status: "getphone",
                    uid: item.attr("uid"),
                    uname: item.attr("uname"),
                    src: item.attr("source"),
                    type: item.attr("type"),
                    src_link: item.attr("url"),
                    skey: getsKey()
                }, function (response) {
                    if (response.status == 200) {
                        item.addClass('found forhanks-copy');                    
                        $('.forhanks-cmt[uid="' + item.attr("uid") + '"]').addClass('found forhanks-copy');
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    else {
                        item.addClass('notfound');
                        $('.forhanks-cmt[uid="' + item.attr("uid") + '"]').addClass('notfound');
                        $('.forhanks-cmt.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    item.removeClass('loading');
                });
            }
        }).promise().done(function () {
            if ($('.uiMorePager a.uiMorePagerPrimary').length < 1 || $('._59s7[role="dialog"] .forhanks-cmt').length < 1) {
                clearInterval(interval);
            }
        });
    }
    
    
}

function scan_all_like() {
    $('.j83agx80.k4urcfbm[role="dialog"] .forhanks-cmt:not(.found,.notfound,.loading,.forhanks-copy)').each(function (key, item) {
        item = $(item);
        if (item.hasClass('loading') || item.hasClass('found') || item.hasClass('notfound')) {
            return true;
        }        
        item.addClass('loading');
        $('.forhanks-cmt.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
        if (chrome && chrome.runtime) {
           
            chrome.runtime.sendMessage({
                status: "getphone",
                uid: item.attr("uid"),
                uname: item.attr("uname"),
                src: item.attr("source"),
                type: item.attr("type"),
                src_link: item.attr("url"),
                skey: getsKey()
            }, function (response) {
                if (response.status == 200) {
                    item.addClass('found forhanks-copy');                    
                    $('.forhanks-cmt[uid="' + item.attr("uid") + '"]').addClass('found forhanks-copy');
                    $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                    $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                }
                else {
                    item.addClass('notfound');
                    $('.forhanks-cmt[uid="' + item.attr("uid") + '"]').addClass('notfound');
                    $('.forhanks-cmt.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                }
                item.removeClass('loading');
            });
        }
    }).promise().done(function () {
        if ($('.j83agx80.k4urcfbm[role="dialog"] .forhanks-cmt').length < 1) {
            clearInterval(interval);
        }
    });
}

function scan_all_member() {

    var url = document.URL;
    if (url.indexOf('m.facebook.com/browse/group/members') >= 0) {
        $('#root .forhanks-user:not(.found,.notfound,.loading,.forhanks-copy)').each(function (key, item) {
            item = $(item);
            if (item.hasClass('loading') || item.hasClass('found') || item.hasClass('notfound')) {
                return true;
            }
            if (isNaN(item.attr("uid"))) {
                return true;
            }
            item.addClass('loading');
            $('.forhanks-user.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            if (chrome && chrome.runtime) {
               
                chrome.runtime.sendMessage({
                    status: "getphone",
                    uid: item.attr("uid"),
                    uname: item.attr("uname"),
                    type: item.attr("type"),
                    src: item.attr("source"),
                    src_link: item.attr("url"),
                    skey: getsKey()
                }, function (response) {
                    if (response.status == 200) {
                        item.addClass('found');                    
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('found');
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    else {
                        item.addClass('notfound');
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('notfound');
                        $('.forhanks-user.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    item.removeClass('loading');
                });
            }

        }).promise().done(function () {
            if ($('#root .forhanks-user').not('.found').length < 1 && $('#root .forhanks-user').not('.notfound').length < 1) {
                clearInterval(interval);
                clearInterval(scroll_interval);
            }
        });
    } else {
        $('#groupsMemberBrowser .forhanks-user:not(.found,.notfound,.loading,.forhanks-copy)').each(function (key, item) {
            item = $(item);
            if (item.hasClass('loading') || item.hasClass('found') || item.hasClass('notfound')) {
                return true;
            }
            if (isNaN(item.attr("uid"))) {
                return true;
            }
            item.addClass('loading');
            $('.forhanks-user.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            if (chrome && chrome.runtime) {
               
                chrome.runtime.sendMessage({
                    status: "getphone",
                    uid: item.attr("uid"),
                    uname: item.attr("uname"),
                    src: item.attr("source"),
                    type: item.attr("type"),
                    src_link: item.attr("url"),
                    skey: getsKey()
                }, function (response) {
                    if (response.status == 200) {
                        item.addClass('found');                    
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('found');
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    else {
                        item.addClass('notfound');
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('notfound');
                        $('.forhanks-user.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    item.removeClass('loading');
                });
            }

        }).promise().done(function () {
            if ($('#groupsMemberSection_recently_joined .forhanks-user').not('.found').length < 1 && $('#groupsMemberSection_recently_joined .forhanks-user').not('.notfound').length < 1) {
                clearInterval(interval);
                clearInterval(scroll_interval);
            }
        });
    }
}

$(document).on('click', '.forhanks-member-all', function (event) {
    interval = setInterval(function () {
        scan_all_member();
    }, 800);

    scroll_interval = setInterval(function () {
        window.scrollTo(0,document.body.scrollHeight);
    }, 3000);
});

$(document).on('click', '.forhanks-cmt-all', function (event) {
    interval = setInterval(function () {
        loadmore();
    }, 800);
});

$(document).on('click', '.forhanks-cmt-all-4', function (event) {
    interval = setInterval(function () {
        scan_all_like();
    }, 800);
});

$(document).on('click', '.forhanks-member-all-4', function (event) {
    interval = setInterval(function () {
        $('.o8rfisnq .obtkqiv7 .forhanks-user:not(.found,.notfound,.loading,.forhanks-copy)').each(function (key, item) {
            item = $(item);
            if (item.hasClass('loading') || item.hasClass('found') || item.hasClass('notfound')) {
                return true;
            }
            if (isNaN(item.attr("uid"))) {
                return true;
            }
            item.addClass('loading');
            $('.forhanks-user.loading[uid="' + item.attr("uid") + '"]').html('Đang Tìm<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
            if (chrome && chrome.runtime) {
               
                chrome.runtime.sendMessage({
                    status: "getphone",
                    uid: item.attr("uid"),
                    uname: item.attr("uname"),
                    type: item.attr("type"),
                    src: item.attr("source"),
                    src_link: item.attr("url"),
                    skey: getsKey()
                }, function (response) {
                    if (response.status == 200) {
                        item.addClass('found');                    
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('found');
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').attr('phone', (response.data).slice(1));
                        $('.forhanks-copy[uid="' + item.attr("uid") + '"]').html('' + response.data + '<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    else {
                        item.addClass('notfound');
                        $('.forhanks-user[uid="' + item.attr("uid") + '"]').addClass('notfound');
                        $('.forhanks-user.notfound[uid="' + item.attr("uid") + '"]').html('Không Thấy<div style="width:10px; float:right;padding-right: 5px;padding-top: 2px;"><img style="width:14px;height:14px" src=""></div>');
                    }
                    item.removeClass('loading');
                });
            }

        }).promise().done(function () {
            /*if ($('.o8rfisnq .obtkqiv7 .forhanks-user:not(.found,.notfound,.loading,.forhanks-copy)').length < 1) {
                clearInterval(interval);
            }*/
        });

    }, 800);
});

///// Chat
$(document).on('click', '.l9j0dhe7[data-pagelet="ChatTab"]', function (event) {
    var item = $('.datstx6m > .pfnyh3mw.tkr6xdv7', this);
    if (!item.attr('added-button') && !item.attr('aria-hidden')) {
        item.attr('added-button', 1);
        let dataName = $('.oo9gr5id[data-testid="messenger-chat-title-text"]', this).text();
        let uid = $('.nc684nl6 a.oajrlxb2[role="link"]', this).attr('href').match("\/(.*)\/")[1];
        let url = "https://fb.com/" + uid;
        let type = 'user_name';
        if(!isNaN($dataId)) {
            type = 'uid';
        }
        item.append('<span style="height:20px;width:20px;"><img class="forhanks-user" source="Inbox" type="'+ type +'"  uid="'+ uid +'" uname="'+ dataName +'" url="'+ btoa(url) +'"></span>');
    }
});