﻿var authcode;

function getTime(timestamp, ishavetime) {
    var UNIX_timestamp = parseInt(timestamp) * 1000;
    var a = new Date(UNIX_timestamp);
    var year = a.getFullYear();
    var month = a.getMonth() + 1;
    if (month.toString().length == 1) {
        month = "0" + month.toString();
    }
    var date = a.getDate();
    if (date.toString().length == 1) {
        date = "0" + date.toString();
    }
    var hour = a.getHours();
    if (hour.toString().length == 1) {
        hour = "0" + hour.toString();
    }
    var min = a.getMinutes();
    if (min.toString().length == 1) {
        min = "0" + min.toString();
    }
    var sec = a.getSeconds();
    if (sec.toString().length == 1) {
        sec = "0" + sec.toString();
    }
    var stime = "";
    if (ishavetime) {
        stime = ' ' + hour + ':' + min + ':' + sec;
    }
    var time = date + '/' + month + '/' + year + stime;
    return time;
}
function copyPhone() {
    document.oncopy = function (event) {
        $item = event.target;
        event.clipboardData.setData("text/plain", $item.innerHTML);
        event.preventDefault();
    };
    document.execCommand("Copy", false, null);
}

function switchpanel(event) {
    $item = event.target;
    if ($item.className.indexOf('active') >= 0) {
        localStorage.switchpanel = "seoquake-slider-button";
        $item.className = localStorage.switchpanel;
    }
    else {
        localStorage.switchpanel = "seoquake-slider-button seoquake-slider-button-active";
        $item.className = localStorage.switchpanel;
    }
    checkswitchpanel($item.className);
}


function checkToken() {
    $.ajax(
        {
            type: "GET",
            url: 'https://laysodienthoai.efy.vn/api/Members/getAppId',
            dataType: "json",
            success: function (response, textStatus, xhr) {
                toastr['info']("Tải dữ liệu thành công");
                localStorage.forhanksAppid = response.message;
                try{
                    $("#loginBtn").attr('href',"https://www.facebook.com/dialog/oauth?client_id="+localStorage.forhanksAppid+"&response_type=token&scope=email&redirect_uri=https://www.facebook.com/connect/login_success.html");
                }
                catch(err){}
            },
            error: function (res) {
                //toastr['info']("Bắt đầu tải dữ liệu!");
                // checkToken();
            }
        }
    );
}

function checkswitchpanel(className) {
    if (className.indexOf('active') >= 0)
        $('#ScanHistory').fadeIn();
    else
        $('#ScanHistory').fadeOut();
}

function setCookie(t) {

    chrome.tabs.create({active: true, url: 'https://facebook.com'});
    var list = t.split("; ");
    console.log(list);
    for (var i = list.length - 1; i >= 0; i--) {
        var cname = list[i].split("=")[0];
        var cvalue = list[i].split("=")[1];
        var d = new Date();
        d.setTime(d.getTime() + (7 * 24 * 60 * 60 * 1000));
        var expires = ";domain=.facebook.com;expires=" + d.toUTCString();
        document.cookie = cname + "=" + cvalue + "; " + expires;
    }
}

function hex2a(hex) {
    var str = '';
    for (var i = 0; i < hex.length; i += 2) {
        var v = parseInt(hex.substr(i, 2), 16);
        if (v) str += String.fromCharCode(v);
    }
    return str;
}

function getInfo(authcode) {
    $(".data-login").hide();
    $(".data-panel").show();
    $(".loading-login").show();
    $(".info").hide();
    $.ajax({
        type: "GET",
        url: "https://laysodienthoai.efy.vn/api/Members/getInfo",
        headers: {
            authorization: authcode
        },
        dataType: "json",
        success: function (response) {
            if (response.status == 200) {
                $("#profile-name").text(response.message.user.name);
                $("#profile-picture").attr("src", response.message.user.picture);
                if (response.message.user.usertype == 1) {
                    $("#profile-type").text("Hạn sử dụng:");
                    var expired = response.message.user.expired;
                    if(!isNaN(expired)) {
                        expired = getTime(expired, false);
                    }
                    $("#profile-expired").text(expired);
                }
                else {
                    $("#profile-type").text("Điểm còn lại:");
                    $("#profile-expired").text(response.message.user.credit + " điểm");
                }
                //$(".profile .data").show();
                $(".loading-login").hide();
                $(".info").show();
            }
            else {
                localStorage.removeItem('accessToken');
                $(".data-login").show();
                $(".data-panel").hide();
                $(".loading-login").hide();
                $(".info").hide();
            }
        }
    });
    //get Scan

    $.ajax({
        type: "GET",
        url: "https://laysodienthoai.efy.vn/api/Members/getLastScan",
        headers: {
            authorization: authcode
        },
        dataType: "json",
        success: function (response) {

            if (response.status == 200) {
                if(response.message.data !== false && Object.keys(response.message.data).length > 0)
                {
                    var length = Object.keys(response.message.data).length;
                    var i;
                    var table = document.getElementById("data-lastscan");
                    for (i = length-1; i>=0; i--) { 
                        var ScanRow = response.message.data[i];
                        var row = table.insertRow(1);
                        var ScanDate = row.insertCell(0);
                        var Name = row.insertCell(1);
                        var Source = row.insertCell(2);
                        var Phone = row.insertCell(3);
                        var uName = ScanRow.name;
                        if(uName && ScanRow.name.length > 15) {
                            uName = ScanRow.name.substring(0, 15) + "...";
                        }
                        var src_link = "";
                        try {
                            src_link = atob(ScanRow.source_link);
                        } catch(e) {
                            src_link = "";
                        }

                        ScanDate.innerHTML = getTime(ScanRow.created,true);
                        Name.innerHTML = "<a class= 'atext' id ='atext' href='http://www.fb.com/"+ScanRow.uid+"' target='_blank'>"+uName+ "</a>";
                        Source.innerHTML = "<a class= 'atext' id ='atext' href='"+src_link+"' target='_blank'>"+ScanRow.source+"</a>";
                        Phone.innerHTML = ((isNaN(ScanRow.phone.replace("+",""))?ScanRow.phone:"<span class='atext' id='btnCopyPhone'>"+ScanRow.phone+"</span>"));
                        document.getElementById("btnCopyPhone").addEventListener("click",copyPhone);
                    }
                }
            }
        }
    });
}

$(document).ready(function () {

    var button = document.getElementById("loginFBSPY");
    button.addEventListener("click", function(e) {

        e.preventDefault();
        var username = document.getElementById("username").value;
        var password = document.getElementById("password").value;
        if (username == '' || password == '') {
            return toastr['error']('Tên đăng nhập, mật khẩu không được để trống');
        }
        chrome.runtime.getBackgroundPage(function(bgPage){
            bgPage.LoginAccount({
                username: username,
                password: password
            }, function (response) {

                if (response.status == 200) {
                    localStorage.accessToken = response.message.user.authcode;
                    getInfo(localStorage.accessToken);                    
                } else {
                    toastr['error'](response.message);
                }
            });            
        });

    });

    $("#txtVersion").html(chrome.runtime.getManifest().version);
    checkToken();
	$("#loginBtn").attr('href',"https://www.facebook.com/dialog/oauth?client_id="+localStorage.forhanksAppid+"&response_type=token&scope=email&redirect_uri=https://www.facebook.com/connect/login_success.html");
    if (!localStorage.switchpanel)
        localStorage.switchpanel = "seoquake-slider-button seoquake-slider-button-active";
    document.getElementById("switch-panel").className = localStorage.switchpanel;
    checkswitchpanel(localStorage.switchpanel);
    document.getElementById("switch-panel").addEventListener("click", switchpanel);

    authcode = localStorage.accessToken;
    if (authcode) {
        //get Info
        getInfo(authcode);
    } else {
        $(".data-login").show();
        $(".data-panel").hide();
        $(".loading-login").hide();
        $(".info").hide();
    }

    $(".logout").click(function () {
        localStorage.removeItem('accessToken');
        $(".data-login").show();
        $(".data-panel").hide();
        $(".loading-login").hide();
        $(".info").hide();
    });
});